package furny.ga.util;

import ga.core.algorithm.util.RandomSingleton;

import java.util.Collections;
import java.util.List;
import java.util.Random;

/**
 * Utility class for handling collections.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public final class CollectionUtils {
  /**
   * Instantiation is not allowed.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  private CollectionUtils() {
  }

  /**
   * Puts a list into a random order. Each element from {@code 0} to {@code n}
   * is exchanged by a random element.
   * 
   * @param list
   *          The list to put into random order.
   * @param <T>
   *          Generic type argument for the collections elements.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public static <T> void randomOrder(final List<T> list) {
    final Random rnd = RandomSingleton.getRandom();

    final int size = list.size();

    for (int i = 0; i < size; i++) {
      final int rndIdx = rnd.nextInt(size);

      Collections.swap(list, i, rndIdx);
    }
  }
}
